﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Update
{
    /// <summary>
    /// Get SAML Token.
    /// </summary>
    public class GetSamlTokenStep : FilterBase<VideoVisitUpdateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitUpdateStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                var currentUser = srv.SystemUserSet.FirstOrDefault(x => x.Id == state.UserId);

                if (currentUser == null) throw new Exception(string.Format("Unable to retrieve user {0} for updating a Video Visit.", state.UserId));
                if (string.IsNullOrEmpty(currentUser.cvt_SAMLToken)) throw new Exception(string.Format("Unable to retrieve SAML token for user {0} for updating a Video Visit.", state.UserId));

                state.SamlToken = currentUser.cvt_SAMLToken;
            }
        }
    }
}